<?php

namespace AppBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * PackRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PackRepository extends EntityRepository
{
	public function count() {
		$query = $this->createQueryBuilder('e')
		                ->select('count(e)')
		                ->where('e.enabled = true')
		                ->getQuery();
		return $query->getSingleScalarResult();
	}
	public function countReviews() {
		$query = $this->createQueryBuilder('e')
		              ->select('count(e)')
		              ->where('e.review = true')
		              ->getQuery();
		return $query->getSingleScalarResult();
	}
	public function Downloads() {
		$query = $this->createQueryBuilder('e')
		              ->select('sum(e.downloads)')
		              ->getQuery();
		return $this->getNumbers($query->getSingleScalarResult());
	}
	public function getNumbers($value) {
		if ($value < 1000) {
			return $value . '';
		} else {
			$value = $value / 1000;
			$units = ['K', 'M', 'B', 'T'];
			foreach ($units as $unit) {
				if (round($value, 2) >= 1000) {
					$value = $value / 1000;
				} else {
					break;
				}
			}
			return round($value, 2) . ' ' . $unit;
		}
	}
}
